unit clsUserDetails;

interface

type

  TUser = class(TObject)
  private
    fName : String;
    fDepartment : String;
    fHireDate : TDateTime;
    fNameChanged : EventHandler;
    fDepartmentChanged : EventHandler;
    fHireDateChanged : EventHandler;
    procedure SetName(Value : String);
    procedure SetDepartment(Value : String);
    procedure SetHireDate(Value : TDateTime);
  public
    constructor Create;
  published
    property Name : String read fName write SetName;
    property Department : String read fDepartment write SetDepartment;
    property HireDate : TDateTime read fHireDate write SetHireDate;
    property NameChanged : EventHandler add fNameChanged remove fNameChanged;
    property DepartmentChanged : EventHandler add fDepartmentChanged remove fDepartmentChanged;
    property HireDateChanged : EventHandler add fHireDateChanged remove fHireDateChanged;
  end;

implementation

{ TUser }

constructor TUser.Create;
begin
  Inherited Create;
  fName := '';
  fDepartment := '';
  fHireDate := TDateTime.Parse('1/1/1990');
end;

procedure TUser.SetDepartment(Value: &String);
begin
  fDepartment := Value;
  if assigned(fDepartmentChanged) then fDepartmentChanged(self,EventArgs.Empty);
end;

procedure TUser.SetHireDate(Value: TDateTime);
begin
  fHireDate := Value;
  if assigned(fHireDateChanged) then fHireDateChanged(Self,Eventargs.Empty);
end;

procedure TUser.SetName(Value: &String);
begin
  fName := Value;
  if assigned(fNameChanged) then fNameChanged(Self,Eventargs.Empty);
end;

end.
